// ===== ANIMATION D'EXTINCTION TV CRT =====
function createTVPowerOffAnimation() {
    // Créer l'overlay d'extinction
    const powerOffHTML = `
        <div class="tv-power-off-overlay" id="tvPowerOff">
            <div class="tv-power-off-screen">
                <div class="tv-power-off-shrink"></div>
                <div class="tv-power-off-flash"></div>
                <div class="tv-power-off-static"></div>
                <div class="tv-power-off-glitch"></div>
                <div class="tv-power-off-flicker"></div>
                <div class="tv-power-off-spot"></div>
                <div class="tv-power-off-sound-wave"></div>
            </div>
            <div class="tv-power-off-text">CRT OFF</div>
        </div>
    `;
    
    document.body.insertAdjacentHTML('afterbegin', powerOffHTML);
    
    // Après l'animation, cacher l'interface TV et afficher l'écran d'extinction
    setTimeout(() => {
        const powerOff = document.getElementById('tvPowerOff');
        powerOff.classList.add('fade-out');
        
        setTimeout(() => {
            powerOff.classList.add('hidden');
            powerOff.remove();
            
            // Cacher l'interface TV complète
            document.querySelector('.tv-retro-container').style.display = 'none';
            
            // Afficher l'écran d'extinction avec le bouton d'accueil
            showPowerOffScreen();
        }, 2000);
    }, 1800);
}

// ===== AFFICHER L'ÉCRAN D'EXTINCTION AVEC BOUTON ACCUEIL =====
function showPowerOffScreen() {
    const powerOffScreenHTML = `
        <div class="tv-power-off-interface" id="tvPowerOffInterface">
            <div class="tv-power-off-frame">
                <div class="tv-power-off-display">
                    <div class="tv-power-off-title">TÉLÉVISION ÉTEINTE</div>
                    <div class="tv-power-off-message">
                        <div class="tv-power-off-icon">
                            <svg viewBox="0 0 24 24" width="48" height="48" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="2" y="7" width="20" height="15" rx="2" ry="2"></rect>
                                <polyline points="17 2 12 7 7 2"></polyline>
                                <line x1="12" y1="22" x2="12" y2="7"></line>
                                <circle cx="12" cy="12" r="1"></circle>
                            </svg>
                        </div>
                        <div class="tv-power-off-status">
                            <span class="tv-power-off-led off"></span>
                            CRT: OFF
                        </div>
                        <div class="tv-power-off-time" id="tvPowerOffTime">--:--:--</div>
                    </div>
                    
                    <div class="tv-power-off-instructions">
                        <div class="tv-power-off-step">
                            <span class="step-number">1</span>
                            <span class="step-text">Pour rallumer la télévision, cliquez sur le bouton</span>
                        </div>
                        <div class="tv-power-off-step">
                            <span class="step-number">2</span>
                            <span class="step-text">Pour revenir à l'accueil, utilisez le bouton ci-dessous</span>
                        </div>
                    </div>
                    
                    <div class="tv-power-off-controls">
                        <button class="tv-power-off-btn power-on" id="tvPowerOnBtn">
                            <span class="btn-icon">
                                <svg viewBox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M18.36 6.64a9 9 0 1 1-12.73 0"></path>
                                    <line x1="12" y1="2" x2="12" y2="12"></line>
                                </svg>
                            </span>
                            RALLUMER LA TV
                        </button>
                        
                        <a href="index.php" class="tv-power-off-btn home-btn">
                            <span class="btn-icon">
                                <svg viewBox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                    <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                </svg>
                            </span>
                            RETOUR À L'ACCUEIL
                        </a>
                    </div>
                    
                    <div class="tv-power-off-footer">
                        <div class="tv-power-off-signal">
                            <div class="signal-bar"></div>
                            <div class="signal-bar"></div>
                            <div class="signal-bar"></div>
                            <div class="signal-bar"></div>
                            <span>NO SIGNAL</span>
                        </div>
                        <div class="tv-power-off-brand">SAE 303 - DATAVISUALISATION</div>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    document.body.insertAdjacentHTML('beforeend', powerOffScreenHTML);
    
    // Mettre à jour l'heure en temps réel
    updatePowerOffTime();
    setInterval(updatePowerOffTime, 1000);
    
    // Gérer le bouton de rallumage
    const powerOnBtn = document.getElementById('tvPowerOnBtn');
    if (powerOnBtn) {
        powerOnBtn.addEventListener('click', function() {
            // Cacher l'interface d'extinction
            const powerOffInterface = document.getElementById('tvPowerOffInterface');
            if (powerOffInterface) {
                powerOffInterface.classList.add('fade-out');
                setTimeout(() => {
                    powerOffInterface.remove();
                }, 500);
            }
            
            // Réafficher l'interface TV
            const tvContainer = document.querySelector('.tv-retro-container');
            if (tvContainer) {
                tvContainer.style.display = 'block';
            }
            
            // Réactiver les effets CRT et mettre à jour le bouton
            setTimeout(() => {
                const toggleBtn = document.getElementById('tvToggleCRT');
                const crtStatus = document.querySelector('.crt-status');
                
                if (toggleBtn) {
                    toggleBtn.innerHTML = '<span class="led"></span> CRT: ON';
                    toggleBtn.classList.add('active');
                }
                
                if (crtStatus) {
                    crtStatus.innerHTML = '<span class="led"></span> CRT: ON';
                }
                
                // Réactiver les effets CRT
                document.querySelector('.tv-retro-container').classList.remove('crt-disabled');
            }, 100);
        });
    }
}

// ===== MISE À JOUR DE L'HEURE POUR L'ÉCRAN D'EXTINCTION =====
function updatePowerOffTime() {
    const now = new Date();
    const hours = now.getHours().toString().padStart(2, '0');
    const minutes = now.getMinutes().toString().padStart(2, '0');
    const seconds = now.getSeconds().toString().padStart(2, '0');
    
    const timeElement = document.getElementById('tvPowerOffTime');
    if (timeElement) {
        timeElement.textContent = `${hours}:${minutes}:${seconds}`;
    }
}

// ===== GESTION DU BOUTON CRT =====
function initCRTToggle() {
    const toggleBtn = document.getElementById('tvToggleCRT');
    const crtStatus = document.querySelector('.crt-status');
    
    if (!toggleBtn) return;
    
    let isCRTOn = true;
    
    toggleBtn.addEventListener('click', function(e) {
        e.stopPropagation();
        
        if (isCRTOn) {
            // Éteindre le CRT
            isCRTOn = false;
            
            // Jouer l'animation d'extinction
            createTVPowerOffAnimation();
            
            // Mettre à jour les boutons
            toggleBtn.innerHTML = '<span class="led off"></span> CRT: OFF';
            toggleBtn.classList.remove('active');
            
            if (crtStatus) {
                crtStatus.innerHTML = '<span class="led off"></span> CRT: OFF';
            }
            
            // Désactiver les effets CRT
            document.querySelector('.tv-retro-container').classList.add('crt-disabled');
            
        } else {
            // Allumer le CRT
            isCRTOn = true;
            
            // Mettre à jour les boutons
            toggleBtn.innerHTML = '<span class="led"></span> CRT: ON';
            toggleBtn.classList.add('active');
            
            if (crtStatus) {
                crtStatus.innerHTML = '<span class="led"></span> CRT: ON';
            }
            
            // Réactiver les effets CRT
            document.querySelector('.tv-retro-container').classList.remove('crt-disabled');
        }
    });
}

// Initialiser au chargement
document.addEventListener('DOMContentLoaded', function() {
    // Attendre un peu pour que l'intro se termine
    setTimeout(() => {
        initCRTToggle();
    }, 4000);
});